/*
 * Decompiled with CFR 0.152.
 */
package com.moulberry.axiom.editor.windows;

import com.moulberry.axiom.UserAction;
import com.moulberry.axiom.clipboard.Placement;
import com.moulberry.axiom.clipboard.Selection;
import com.moulberry.axiom.configuration.Configuration;
import com.moulberry.axiom.editor.EditorWindowType;
import com.moulberry.axiom.editor.ImGuiHelper;
import com.moulberry.axiom.editor.keybinds.Keybinds;
import com.moulberry.axiom.editor.windows.MainMenuBar;
import com.moulberry.axiom.editor.windows.operations.QuickFillWindow;
import com.moulberry.axiom.editor.windows.operations.QuickReplaceWindow;
import com.moulberry.axiom.i18n.AxiomI18n;
import com.moulberry.axiom.tools.ToolManager;
import imgui.ImGui;
import imgui.type.ImBoolean;

public class PlacementOptionsOverlay {
    public static void render(int x, int y) {
        if (Placement.INSTANCE.isPlacing()) {
            PlacementOptionsOverlay.renderPlacement(x, y);
        } else if (!Selection.getSelectionBuffer().isEmpty()) {
            PlacementOptionsOverlay.renderSelection(x, y);
        }
    }

    private static void renderPlacement(int x, int y) {
        ImGui.setNextWindowPos(x - 10, y + 10, 1, 1.0f, 0.0f);
        ImBoolean open = new ImBoolean(true);
        String title = AxiomI18n.get("axiom.editorui.window.clipboard.placement_options");
        if (ImGui.begin(title, open, 2101572)) {
            if (ImGui.checkbox(AxiomI18n.get("axiom.editorui.window.clipboard.placement_options.keep_existing"), Placement.INSTANCE.keepExisting)) {
                Placement.INSTANCE.keepExisting = !Placement.INSTANCE.keepExisting;
            }
            ImGui.sameLine();
            if (ImGui.checkbox(AxiomI18n.get("axiom.editorui.window.clipboard.placement_options.paste_air"), Placement.INSTANCE.pasteAir)) {
                boolean bl = Placement.INSTANCE.pasteAir = !Placement.INSTANCE.pasteAir;
            }
            if (ImGui.checkbox("Merge Blocks", Placement.INSTANCE.prioritizeFullBlocks)) {
                boolean bl = Placement.INSTANCE.prioritizeFullBlocks = !Placement.INSTANCE.prioritizeFullBlocks;
            }
            if (Placement.INSTANCE.keepExisting) {
                ImGuiHelper.tooltip("Merges new blocks with existing blocks based on block shape:\nIf the new block completely overlaps the old block, the new block is used\nOtherwise, the old block is used\n(Inverts if Keep Existing is disabled)");
            } else {
                ImGuiHelper.tooltip("Merges new blocks with existing blocks based on block shape:\nIf the old block completely overlaps the new block, the old block is used\nOtherwise, the new block is used\n(Inverts if Keep Existing is enabled)");
            }
            ImGui.sameLine();
            if (ImGui.checkbox(AxiomI18n.get("axiom.editorui.window.clipboard.unlock_rotation"), Placement.INSTANCE.unlockRotation)) {
                boolean bl = Placement.INSTANCE.unlockRotation = !Placement.INSTANCE.unlockRotation;
                if (Placement.INSTANCE.unlockRotation && Configuration.internal.showNon90DegreeRotationWarning) {
                    ImGui.openPopup("###RotationWarning");
                }
            }
            ImGuiHelper.tooltip("Allows for rotation by angles less than 90 degrees");
            if (ImGuiHelper.beginPopupModal(AxiomI18n.get("axiom.editorui.window.clipboard.warning_title") + "###RotationWarning", 68)) {
                ImGui.text(AxiomI18n.get("axiom.editorui.window.clipboard.warning_1"));
                ImGui.text(AxiomI18n.get("axiom.editorui.window.clipboard.warning_2"));
                if (ImGui.button(AxiomI18n.get("axiom.editorui.warning_confirmation"))) {
                    Configuration.internal.showNon90DegreeRotationWarning = false;
                    ImGui.closeCurrentPopup();
                }
                ImGui.endPopup();
            }
            if (ImGui.button(AxiomI18n.get("axiom.editorui.window.clipboard.placement_options.rotate_scale"))) {
                EditorWindowType.ROTATE_PLACEMENT.setOpen(true);
            }
            ImGui.sameLine();
            if (ImGui.button("Snap to ground")) {
                Placement.INSTANCE.snapToGround();
            }
            if (ImGui.button("Paste (Enter)")) {
                Placement.INSTANCE.pastePlacement();
            }
            ImGui.sameLine();
            if (ImGui.button("Paste Copy")) {
                Placement.INSTANCE.pastePlacementWithoutStopping(false);
            }
            if (ImGui.button("Paste and Select")) {
                Placement.INSTANCE.pastePlacement(true);
            }
        }
        ImGui.end();
        if (!open.get()) {
            Placement.INSTANCE.stopPlacement();
        }
    }

    private static void renderSelection(int x, int y) {
        ImGui.setNextWindowPos(x - 10, y + 10, 1, 1.0f, 0.0f);
        ImBoolean open = new ImBoolean(true);
        String title = "Selection Options";
        if (ImGui.begin(title, open, 2101572)) {
            if (ImGui.button(AxiomI18n.get("axiom.tool.selection.clear_selection", "Enter"))) {
                Selection.clearSelection();
            }
            ImGui.separator();
            if (ImGui.button(AxiomI18n.get("axiom.tool.selection.fill_selection", Keybinds.QUICK_FILL.shortKeyIdentifier()))) {
                if (ToolManager.isToolActive()) {
                    ToolManager.getCurrentTool().reset();
                }
                QuickFillWindow.openQuickFillWindow = true;
            }
            ImGui.sameLine();
            if (ImGui.button(AxiomI18n.get("axiom.tool.selection.replace_selection", Keybinds.QUICK_REPLACE.shortKeyIdentifier()))) {
                if (ToolManager.isToolActive()) {
                    ToolManager.getCurrentTool().reset();
                }
                QuickReplaceWindow.openQuickReplaceWindow = true;
            }
            ImGui.separator();
            if (ImGui.button(AxiomI18n.get("axiom.tool.selection.copy_selection", Keybinds.COPY.shortKeyIdentifier()))) {
                if (ToolManager.isToolActive()) {
                    ToolManager.getCurrentTool().reset();
                }
                Selection.callAction(UserAction.COPY, null);
            }
            ImGui.sameLine();
            if (ImGui.button(AxiomI18n.get("axiom.tool.selection.cut_selection", Keybinds.CUT.shortKeyIdentifier()))) {
                if (ToolManager.isToolActive()) {
                    ToolManager.getCurrentTool().reset();
                }
                Selection.callAction(UserAction.CUT, null);
            }
            if (ImGui.button(AxiomI18n.get("axiom.tool.selection.duplicate_selection", Keybinds.DUPLICATE.shortKeyIdentifier()))) {
                if (ToolManager.isToolActive()) {
                    ToolManager.getCurrentTool().reset();
                }
                Selection.callAction(UserAction.DUPLICATE, null);
            }
            ImGui.separator();
            MainMenuBar.renderOperationsImgui(false);
        }
        ImGui.end();
        if (!open.get()) {
            Selection.clearSelection();
        }
    }
}

